
 
; Charger Adaptor

;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT	

; RAM 

STORE1				equ	H'20'	; delay counter	
STORE2				equ	H'21'	; delay counter
STORE3				equ	H'22'	; delay counter
BATT_V				equ	H'23'	; battery volts (AN1)
BATT_V_LAST		equ	H'24'	; previous battery voltage
CHARGE_V			equ	H'25'	; charge voltage value (voltage) (AN0)
TEMP				equ	H'26'	; temporary
T1					equ	H'27'	; tally for averaging
T2					equ	H'28'	; tally for averaging
T3					equ	H'29'	; tally for averaging
T4					equ	H'2A'	; tally for averaging
T5					equ	H'2B'	; tally for averaging
T6					equ	H'2C'	; tally for averaging
T7					equ	H'2D'	; tally for averaging
T8					equ	H'2E'	; tally for averaging
ADDITION_LS		equ	H'2F'	; addition of T1-T8
ADDITION_MS		equ	H'30'	; addition of T1-T8	
LOOP				equ	H'31'	; loop counter	
BATT_V_AV			equ	H'32'	; Average battery voltage
ADD_FLG			equ	H'33'	; addition counter for flag
FLAG				equ	H'34'	; flag for when averaging is ready when first started

; start at memory 0

	org		0	; reset vector
	    			; interrupt vector (not used)
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'	 		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf		GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00000000'	; pullups off  
	movwf	WPU
	movlw	B'00001011'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'10000000'	; settings (pullups disabled) 
	movwf	OPTION_REG
	movlw	B'00010010'	;  AN1 A/D Tosc/8
	movwf	ANSEL		; digital I/O
	bcf		STATUS,RP0; select memory bank 0

; analog inputs, A/D

	movlw	B'00000101'	; A/D on, channel 1, left justified, VDD ref.  
	movwf	ADCON0

; initial conditions
	clrf		GPIO

; Wait for battery connection
NO_BATT1

; read AN1 for battery connection before starting charge
	call		READ_BATT
	movlw	D'140'		; 9V minimum
	subwf	ADRESH,w
	btfss	STATUS,C
	goto	NO_BATT1

; start up delay ~3s
	movlw	D'14'		; delay extension
	call		TIMER		; delay

; check battery connection again
NO_BATT2
	movlw	D'7'		; delay extension
	call		TIMER	; delay
; read AN1 for battery connection before starting charge
	call		READ_BATT
	movlw	D'155'		; 10V minimum
	subwf	ADRESH,w
	btfss	STATUS,C
	goto	NO_BATT2

 ; light Charging LED
	bsf		GPIO,5 	

; start up delay ~1s
	movlw	D'7'			; delay extension
	call		TIMER		; delay

; Charge Cycle
; switch on RELAY1
	bsf		GPIO,2		; set high for Relay1 on
	clrf		BATT_V_LAST	; previous battery voltage 
	clrf		BATT_V_AV	; averaged battery voltage
	clrf		T1			; battery voltage tally
	clrf		T2
	clrf		T3
	clrf		T4			; battery voltage tally
	clrf		T5
	clrf		T6
	clrf		T7			; battery voltage tally
	clrf		T8
	movlw	D'8'
	movwf	ADD_FLG
	clrf		FLAG
	goto	CONTINUE_CHARGE

LED_ON_OFF
; check if battery voltage is dropping (ie charger is off)
; increase battery voltage value a little first
	movlw	D'3'
	addwf	BATT_V,w
	movwf	TEMP
	movlw	H'FF'
	btfsc	STATUS,C	; if carry then set at FF
	movwf	TEMP

	movf	TEMP,w
; use BATT_V_LAST or BATT_V_AV
	btfss	FLAG,0		; if set, use average
	goto	FIRST 
	subwf	BATT_V_AV,w ;
	btfsc	STATUS,C
	goto	OFF		; battery voltage is dropping
	goto	TRANS

FIRST; values before average is ready
	subwf	BATT_V_LAST,w
	btfsc	STATUS,C
	goto	OFF		; battery voltage is dropping

TRANS
; check if flag is clear
	btfsc	FLAG,0
	goto	BY
; transfer BATT_V to BATT_V_LAST but only if BATT_V is > BATT_V_LAST
	movf	BATT_V,w
	subwf	BATT_V_LAST,w
	btfsc	STATUS,C
	goto	CK_10
BY
	movf	BATT_V,w
	movwf	BATT_V_LAST
; average of last 8 battery voltage readings place in BATT_V_AV
; shift to revise avarage

	movf	T7,w
	movwf	T8
	movf	T6,w
	movwf	T7
	movf	T5,w
	movwf	T6
	movf	T4,w
	movwf	T5
	movf	T3,w
	movwf	T4
	movf	T2,w
	movwf	T3
	movf	T1,w
	movwf	T2
	movf	BATT_V,w
	movwf	T1
	goto	ADD_UP

; mini subroutine
ADD
	addwf	ADDITION_LS,f
	btfsc	STATUS,C	; if over increase MS byte
	incf		ADDITION_MS,f
	return

; add up the 8 records
ADD_UP
	movf	ADD_FLG,w
	btfsc	STATUS,Z		; if clear set flag
	bsf		FLAG,0
	decf	ADD_FLG,f		; decrease and flag set when all suitable additions are complete. ie T1-T8are not 0 but actual readings

	clrf		ADDITION_MS
	clrf		ADDITION_LS
	movf	T1,w
	call		ADD
	movf	T2,w
	call		ADD
	movf	T3,w
	call		ADD
	movf	T4,w
	call		ADD
	movf	T5,w
	call		ADD
	movf	T6,w
	call		ADD
	movf	T7,w
	call		ADD
	movf	T8,w
	call		ADD

; divide by 8
DIV ; divide
; by 2
	bcf		STATUS,C	; start by clearing carry
	rrf		ADDITION_MS,f
	rrf		ADDITION_LS,f
; by 4
	bcf		STATUS,C	; start by clearing carry
	rrf		ADDITION_MS,f
	rrf		ADDITION_LS,f
; by 8
	bcf		STATUS,C	; start by clearing carry
	rrf		ADDITION_MS,f
	rrf		ADDITION_LS,f

; place average in BATT_V_AV	
	movf	ADDITION_LS,w
	movwf	BATT_V_AV

CK_10
;  check for below 10V
	movlw	D'155'		; 10V minimum
	subwf	BATT_V,w
	btfsc	STATUS,C
	goto	CONTINUE_CHARGE
OFF
	bcf		GPIO,2		; relay off
	nop
	nop
	nop
	nop
	nop
	bcf		GPIO,5		; charging LED off	
	goto	NO_BATT1

CONTINUE_CHARGE

; flash LED2
	movlw	D'3'			; delay extension
	call		TIMER		; delay
	bcf		GPIO,5		; LED off	
	movlw	D'3'			; delay extension
	call		TIMER		; delay
	bsf		GPIO,5		; LED on	
; check charge threshold with battery
	call		THRESH	; returns with 1 or 0 (1 is when battery Voltage is over threshold)
	xorlw	D'0'
	btfsc	STATUS,Z	 
	goto	LED_ON_OFF

; Charged detected
;  check again
	movlw	D'3'			; delay extension
	call		TIMER		; delay
; check charge threshold with battery
	call		THRESH	; returns with 1 or 0 (1 is over threshold)
	xorlw	D'0'
	btfsc	STATUS,Z
	goto	LED_ON_OFF

; switch off relay1
	bcf		GPIO,2		; Charge Relay 1 off.
; LED2 stays on

; Activate kill switch using relay2
; switch on RELAY2 for 5s after 5s
	movlw	D'33'		; delay extension
	call		TIMER		; delay
	bsf		GPIO,4		; RELAY2 on
	movlw	D'33'		; delay extension
	call		TIMER		; delay
	bcf		GPIO,4		; RELAY2 off

; End of charging

; check if <12.5V

BATT_DOWN
	movlw	D'7'		; delay extension
	call		TIMER	; delay
; read AN1 for battery under 12.5V
	call		READ_BATT
	movlw	D'195'		; 12.5V 
	subwf	ADRESH,w
	btfsc	STATUS,C
	goto	BATT_DOWN
; once charged, restart charge when battery drops to 12.5V or 25V (12V or 24V battery)
	movlw	D'7'		; delay extension
	call		TIMER	; delay
; read AN1 for battery connection.If below 10V switch off charge LED 
	call		ACQUIRE_AD
	movlw	D'140'		; 9V minimum
	subwf	ADRESH,w
	btfss	STATUS,C
	bcf		GPIO,5		; LED off when below 10V
	goto	NO_BATT1

; *********************************************
; subroutines

THRESH
; compares charge value with battery
; read battery at AN1
	call		READ_BATT
	movf	ADRESH,w
	movwf	BATT_V			; battery volts
; read setting at AN0
	movlw	B'00000001'	; A/D on, channel 0, left justified, VDD ref.  
	movwf	ADCON0
	call		ACQUIRE_AD
	movf	ADRESH,w	; required charge voltage
	subwf	BATT_V,w
	btfss	STATUS,C
	retlw	D'0'			; battery not charged
	retlw	D'1'			; battery charged


READ_BATT
; read battery at AN1
	movlw	B'00000101'	; A/D on, channel 1, left justified, VDD ref.  
	movwf	ADCON0
; subroutine to wait for A/D conversion
ACQUIRE_AD
; wait ~20us. 
	movlw	D'10'
	movwf	STORE1		; STORE1 is number of loops value
LOOP12
	decfsz	STORE1,f
	goto	LOOP12
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; delay loop 
TIMER
	movwf 	STORE3
DEL_CONT1
	movlw	H'FF'		; delay routine
	call		DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT1	

DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return



	end
